      real*8 function epCompScrBr(z,  y)
      implicit none
#include "Zglobalc.h"
#include "ZbasicCnst.h"

c         give complete screening brems cross-section
c        by Tsai's formula. (R.M.P,  Eq.3.81)
c          
      real*8 z  ! input.  atomic number of the media
      real*8 y  ! input.  Eg/Ee
c     function value ! output. dsigma/dy in mb
c
      real*8 Lrad,  Lradp
      real*8 zsave, z2, f
      save zsave, Lrad, Lradp, z2, f

      data zsave /0./

      if(zsave .ne. z) then
         zsave = z
         call epGetLrad(z, Lrad, Lradp, f)
         z2 = z*z
      endif
c
      epCompScrBr = 4.* ar02 * (
     *          (4./3.- 4./3.*y + y*y) * (
     *         z2 * (Lrad-f) + z*Lradp  )
     *       + (1-y)*(z2 + z)/9.)/y

      end
c     ***************************************
      subroutine epGetLrad(z, Lrad, Lradp, f)
      implicit none          

      real*8 z  ! input.  atomic number of the media
c
      real*8 Lrad  ! output. See Tsai's formula. (R.M.P,  Eq.3.81)
      real*8 Lradp ! ouptut.
      real*8 f     ! output.  Coulomb correction func.

      real*8 z2, z3
      real*8 epCoulombC


      f = epCoulombC((z/137.)**2)         
      z2 = z*z
      if(z .eq. 1.0) then
         Lrad = 5.31
         Lradp = 6.144
      elseif(z .eq. 2.0) then
         Lrad = 4.70
         Lradp = 5.621
      elseif(z .eq. 3.0) then
         Lrad = 4.74
         Lradp = 5.8505
      elseif(z .eq. 4.) then
         Lrad = 4.71
         Lradp = 5.924
      else
         z3=z**(-0.3333333)
         Lrad = log(184.15*z3)
         Lradp = log(1194.0*z3**2)
      endif
      end
