c     ****************************************************************
c     *                                                              *
c     * fbrem: brems and pair prob/r.l.  with the landau effect      *
c     *                                                              *
c     ****************************************************************
c
c
c     complete screening + landau effect.  vv=eg/e, ein gev. prob. in d
c
c
c
c
      function fbrem(vv)
c
      common /landuc/  x0cm, x0g, s1, alogs1, sconst
c
      common /landu1/e
      data er/0.005/,eps/0.0001/
      v=vv
      if(v.eq.1.) go to 20
      if(v.ne.0.) go to 10
      fbrem=0.
      return
   20 continue
      fbrem=(v*v+2.*(1.+(1.-v)*(1.-v)))/v/3.
      return
   10 continue
      s=1.
      s=sbrem2(v,e,s)
      if(s.gt.1.5) goto 20
      s=smigb(v,e,s,er)
   55 continue
      fbrem=gzai(s)/v*(v*v*gmigdl(s,eps)+2.*(1.+(1.-v)*(1.-v))*
     *    psimig(s, eps))/3.
c
c     note that as v-->0, gzai(s) becomes 2 and
c     fbrem---> 2/v *( v*v*12pi*s**2 + 2*(1+(1-v)**2 )* 6 s) )/3
c               where s---> sqrt( sconst*v/2/e/(1-v))
c               so that fbrem--->8*sqrt(2*sconst/v/e)
c
      return
c
c
c     ***********
      entry fpair(vv)
c     ***********
c
c
      v=vv
      if(v.eq.1. .or. v.eq.0.) go to 60
      go to 100
   60 continue
      fbrem=(1.+2.*(v*v+(1.-v)*(1.-v)))/3.
      return
  100 continue
      s=1.
       s=spair2(v,e,s)
      if(s.gt.2.) go to 60
      s=smigp(v,e,s,er)
  105 continue
      fbrem=gzai(s)/3.*(gmigdl(s,eps)+2.*(v*v+(1.-v)*(1.-v))*
     *   psimig(s,eps))
      end
c     ****************************************************************
c     *                                                              *
c     * smigb:  get root s, from recursive relation                  *
c     *                                                              *
c     ****************************************************************
c
c
      function smigb(v,e,s,er)
c
c
    5 continue
      ss=sqrt(sbrem2(v,e,s))
      if(abs((s-ss)/ss).lt.er) goto 10
      s=ss
      goto 5
   10 continue
      smigb=ss
      return
c
c
c     ***********
      entry smigp(v,e,s,er)
c     ***********
c
c
   15 continue
      ss=sqrt(spair2(v,e,s))
      if(abs((s-ss)/ss).lt.er) go to 20
      s=ss
      go to 15
   20 continue
      smigb=ss
      return
      end
c     ****************************************************************
c     *                                                              *
c     * sbrem2:  auxliary function for brem with landau effect       *
c     * spair2:  //                    pair                          *
c     *                                                              *
c     ****************************************************************
c
c
      function sbrem2(v,e,s)
c
c
c
c
      common /landuc/  x0cm, x0g, s1, alogs1, sconst
c
      tmp=sconst*v
   10 continue
      sbrem2=tmp/(1.-v)/e/gzai(s)
      return
      entry spair2(v,e,s)
      tmp=sconst/v
      go to 10
      end
c     ****************************************************************
c     *                                                              *
c     * gzai:  gzai function which appear in ladanu effect           *
c     *                                                              *
c     ****************************************************************
c
c
      function gzai(s)
c
c
c     data s1/5.636e-4/,alogs1/-7.481/        for z=82;lead
c
      common /landuc/  x0cm, x0g, s1, alogs1, sconst
c
      if(s.lt.1.) go to 10
      gzai=1.
      return
   10 if(s.le.s1) go to 20
      gzai=alog(s)/alogs1+1.
      return
   20 gzai=2.
      return
      end
c     ****************************************************************
c     *                                                              *
c     * gmigdl:  g(s) function which appear in landau effect         *
c     * psimig:  pis(s) //                                           *
c     *                                                              *
c     ****************************************************************
c
c             .... psiim is needed.....
c
      function gmigdl(s,eps)
c
c
      data pi12,pi6/37.699112,18.849556/
      gmigdl=(pi12*s-48.*s*s*psiim(s+0.5,s,0,eps))*s
      return
c
c     ************
      entry psimig(s,eps)
c     ************
c
c
      gmigdl=((psiim(s,s,1,eps)*s*24.-pi6)*s+6.) *s
      return
      end
c     ****************************************************************
c     *                                                              *
c     * zpart:  z-dependent part of brems and pair functions const   *
c     *         with the landau effect                               *
c     *                                                              *
c     ****************************************************************
c
c      /usage/
c          call  zpart(z,a,rho)
c       z:  charge
c       a:  mass no.
c     rho:  density in g/cm**3
c
c
      subroutine zpart(z,a, rho)
c
c
      common /landuc/  x0cm, x0g, s1, alogs1, sconst
c
c        get r.l.
c
c     call kradl(za, aa, rn, n, rho, x0cm, x0g)
      call kradl(z, a, 1., 1,   rho, x0cm, x0g)
c
      s1=    ( z**0.3333333/ 183 )**2
      alogs1=alog(s1)
c        const in eq.60 of migdal's paper. phys. rev. vol 103 1956
c         energy is in gev
      sconst=( 1.37e3 ) **2  * x0cm  * 0.511e-3
c
c
      write(6,10) z, a, rho, x0cm, x0g, s1, alogs1, sconst
   10 format('0*** constant used in landau effect'/
     *  ' z=',f7.2, ' a=',f7.2, ' rho=', f7.2, ' x0=', f7.3, 'cm',
     *  '=', f7.3,'g/cm**2', '  s1=',g9.3, ' ln(s1)=',g9.3,
     *  '  const in eq.60 of migdal=', g9.3)
c
      return
      end
