c      parameter (n=8)
c      real*8 za(n), aa(n), rn(n)
c      data  za/6., 1., 8., 7., 14., 20., 13., 5./
c      data  aa/12.01, 1., 16., 14., 28.09, 40.08, 26.98, 10.8/
c      data  rn/28., 34.,22., 1., 6., 3., 2., 4./
c      call kradl(za, aa, rn,  n, 1.75d0,     x0cm, x0g)
c      write(*,*) ' x0cm=',x0cm, ' x0g=',x0g
c      sumz=0.
c      suma=0.
c      sum =0.
c      do 100 i=1, n
c         sumz=sumz+rn(i)*za(i)
c         suma=suma+rn(i)*aa(i)
c         sum=sum+rn(i)
c 100  continue
c      write(*,*) ' <z>=',sumz/sum, ' <a>=',suma/sum
c      end
c     ****************************************************************
c     *
c     * kradl: compute radiation length of mixed matter
c     *
c     ****************************************************************
c
c   call kradl(za, aa, rn, n, rho, x0cm, x0g)
c           input
c      za: charge za(i),i=1,n
c      aa: atomic mass   aa(i),i=1,n
c      rn: relative # of atmos  rn(i),i=1,n
c       n: # of different atoms
c     rho: average density  (g/cm**3)
c
c           output
c      x0cm: r.l in cm
c       x0g: r.l in g/cm**2
c
       subroutine kradl(za, aa, rn, n, rho, x0cm, x0g)
       implicit none
       integer n         
       real*8 za(n)
       real*8 aa(n)
       real*8 rn(n)
       real*8 rho

       real*8 x0cm
       real*8 x0g
c
       real*8 sum, x0i ,tmp
       integer i

       sum=0.
       do   i=1, n
           sum=sum + rn(i)*aa(i)
       enddo
       x0i=0.
       do   i=1, n
           call kradl1(za(i), aa(i), tmp)
           x0i=x0i + rn(i)*aa(i)/sum/tmp
       enddo
       x0g=1./x0i
       x0cm=x0g/rho
      end
c     ****************************************************************
c     *                                                              *
c     * kradl1:  compute radiation length of given matter            *
c     *                                                              *
c     *********************** tested 80.07.11 ************************
c
c   /usage/
c            call kradl1(z, a, x0g)
c
c    z:  charge of the matter
c    a:  mass no.
c  x0g:  //                           g/cm**2
c
c
c     *** note ***
c
c         correction to born approximation is not included in this
c         r.l so it must be included in the cross-section.
c
c
c
      subroutine kradl1(z, a, x0g)
      implicit none
      real*8 z
      real*8 a
      real*8 x0g
c
c         cnst=
c         4/137* r0**2 * n  where r0 is the classical electron radius
c                           n the avogadro number
c                           r0=2.8176e-13 cm
c                           n=6.0247
c

      real*8  cnst/1.396e-3/
      real*8 z3, logz3, gzai, t0inv
c

      z3 = z**(-0.3333333)
      logz3 = log( 183.* z3 )
      gzai = log(1440. * z3**2 ) /  logz3
c        inverse of r.l in g/cm**2
      t0inv = cnst / a  *  z*( z + gzai ) * logz3
c
      x0g=1. / t0inv
      end
