c            test eptransVect
c       implicit none
ccc #include "Zdirec.h"
c#include "ZepDirec.h"
c
c       record /epDirec/ wa, dc, ans1, ans2
c
c       real*8 cst, snt, fai
c       wa.x=-0.1
c       wa.y=-0.34
c       wa.z=-sqrt(1.d0 - (wa.x**2+wa.y**2))
c       cst=0.8d0
c       snt=sqrt(1.d0-cst**2)
c       do fai=0.d0, 2*3.1415, 0.1d0
c          dc.x=snt*cos(fai)
c          dc.y=snt*sin(fai)
c          dc.z=cst
c          call eptransVect(wa, dc, ans1)
c          write(*,*) sngl(ans1.x), sngl(ans1.y),
c     *    sngl(ans1.z)
c          call eptransVect(wa, dc, ans2)
c          write(*,*) ans1.x-ans2.x, ans1.y-ans2.y, ans1.z-ans2.z
c       enddo
c       end
       subroutine eptransVect(zax, dir1, dir2)
       implicit none
#include "ZepDirec.h"
       record /epDirec/  zax   ! input
       record /epDirec/  dir1  ! input
       record /epDirec/  dir2  ! output. can dir1 / zax

       real*8   epsx

       parameter ( epsx=1.d-6 )

c
c         Directions cosines(dir1) are given in a system
c         (=R) whose z-axis has direction cosines (zax) in
c         a certain system(=B).
c         This subroutine transform the angles so that (dir1)
c         be the direction cosines in the B-system,
c         and put the result into dir2.
c         The x and y
c         axes of the R-sysetm are chosen so that the transformation
c         becomes simplest. This does not guarantee that the dir2
c         have the same sing as the original one when zax.z is
c         1.0 or close to 1.0.   
c      dir2 can be the same one as dir1, or zax.
c      dir1 need not be  the direction cosine, but can be momentum 
c          or arbitrary  vector.  zax must be direction cos.
c
       real*8 w1a, w2a, w3a, dc1, dc2, dc3, el2, em2, d, a, b, c
       real*8 tmpa, tmpb, tmpc, temp

          w1a=zax.x
          w2a=zax.y
          w3a=zax.z
          dc1=dir1.x
          dc2=dir1.y
          dc3=dir1.z
c
          el2=w1a**2
          em2=w2a**2
          d=1.+w3a
          if(abs(d) .gt. epsx) then
             a=el2/d - 1.
             b=w1a*w2a/d
             c=em2/d - 1.
             tmpa=a*dc1 + b*dc2 + w1a*dc3
             tmpb=b*dc1 + c*dc2 + w2a*dc3
          else
             tmpa= dc2
             tmpb= dc1
          endif
          tmpc=w1a*dc1 + w2a*dc2 + w3a*dc3
          dir2.x=tmpa
          dir2.y=tmpb
          dir2.z=tmpc
          temp = dir2.x**2 + dir2.y**2 + dir2.z**2
          if(abs(dir2.x) .gt. 1.d0 .or. 
     *         abs(dir2.y) .gt. 1.d0 .or. 
     *         abs(dir2.z) .gt. 1.d0 .or. 
     *         abs(temp -1.d0) .gt. epsx) then
c           renormalize
             temp = sqrt(temp)
             if(temp .eq. 0.) then
                dir2.x = 0.d0
                dir2.y = 0.d0
                dir2.z = 1.d0
             else
                dir2.x = dir2.x/temp
                dir2.y = dir2.y/temp
                dir2.z = dir2.z/temp
             endif
          endif
          end
