c    This is to manage a new non-default  volume/shape which is not
c    included in Epics.

      subroutine epbNew(comp,  posl, dirl, length, icon)
      implicit none
#include "ZepPos.h"
#include "ZepDirec.h"
#include "Zep3Vec.h"
#include "Zcnfig.h"
      record /Component/comp  ! input. given component
      record /epPos/ posl  ! input. position given in local coord.
      record /epDirec/ dirl ! input. direction cos. given in
                            !   local  coordinate
      real*8  length  ! output. minimum length to the boundary of 'comp'
c                          from posl with dirl
      integer icon    ! output.
c                       0-->length obtained. pos  is  inside 
c                       1-->length obtained. pos  is  outside
c                      -1-->not cross 
c 
      integer uscl
c           compute the minimum length to the boundary
      call epseeUnderScore(comp.struc, uscl)
      if(comp.struc(1:uscl) .eq. 'honeycomb') then
         call epbhoneycomb(comp, posl, dirl,  length, icon)
c---  elseif(comp.struc(1:uscl) .eq. '%2') then
c---     call epb%2(comp, posl, dirl,  length, icon)
      else
         call cerrorMsg(comp.struc(1:8), 1)
         call cerrorMsg(' is not supported: epbNew. Maybe', 1)
         call cerrorMsg(
     *   " You haven't done mkNewVolume 'your-config-file'", 0)
      endif

      end
c     ***********************************
      subroutine epsNew(comp, pos, icon)
      implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepPos.h"
c             see if pos is inside the comp component

      record /Component/  comp
      record /epPos/pos  ! input. given point
      integer icon  !   output.  0-->inside. 1-->outside

      integer uscl

      call epseeUnderScore(comp.struc, uscl)
      if(comp.struc(1:uscl) .eq. 'honeycomb')  then
         call epshoneycomb(comp, pos, icon)
c---  elseif(comp.struc(1:uscl) .eq. '%2')  then
c---     call eps%2(comp, pos, icon)
      else
         call cerrorMsg(trim(comp.struc), 1)
         call cerrorMsg(' is not supported: epsNew', 0)
      endif
         
      end
c     ***********************************
      subroutine eprNew(comp, shape)
      implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"
      
      record /Component/ comp  ! input/output. where config data is put

      character*(*)  shape     ! input.  config data has this shape
c            read configuration data 
      integer uscl
      call epseeUnderScore(shape, uscl)
      if(shape(1:uscl)  .eq. 'honeycomb') then
         call eprhoneycomb(comp)
c---  elseif(shape(1:uscl)  .eq. '%2') then
c---     call epr%2(comp)
      else
         call cerrorMsg(trim(shape), 1)
         call cerrorMsg(' is not supported: eprNew ', 0)
      endif

      end
c     ***********************************
      subroutine epenvlpNew(comp,  orig, abc)
      implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"
#include "ZepPos.h"

c         returns  box parameters which envelopes the
c         given component comp. (local cordinate).
c         
      record /Component/ comp  ! input. given component
      record /epPos/ orig      ! output. origin
      record /ep3Vec/ abc      ! output. a,b,c of the box.
      integer uscl

      call epseeUnderScore(comp.struc, uscl)

      if(comp.struc(1:uscl) .eq. 'honeycomb') then
         call epenvlphoneycomb(comp, orig, abc)
c---  elseif(comp.struc(1:uscl) .eq. '%2') then
c---     call epenvlp%2(comp, orig, abc)
      else
         call cerrorMsg(comp.struc(1:8), 1)
         call cerrorMsg(' is not supported: epenvlpNew', 0)
      endif
      end
c     ***********************************
      subroutine epatlocNew(comp, loc)
      implicit none
#include "Zep3Vec.h"
#include "Zcnfig.h"
c
c         
      record /Component/ comp  ! input. given component
      integer loc(*)     !  output. loc(i) is the location of the 
                         !  attribute given in the i-th position in
                         !  the config file. It's value is in 
                         !  Volat( comp.vol + loc(i)).
                         !  loc size must be >= comp.Nattributes
      integer uscl

      call epseeUnderScore(comp.struc, uscl)

      if(comp.struc(1:uscl) .eq. 'honeycomb') then
         call epatlochoneycomb(comp, loc)
c---  elseif(comp.struc(1:uscl) .eq. '%2') then
c---     call epatloc%2(comp, loc)
      else
         call cerrorMsg(comp.struc, 1)
         call cerrorMsg(' is not supported: epatlocNew', 0)
      endif
      end

