#!/bin/bash
work=../Work
if [ $#  -ne  6 ] ; then
cat <<EOF
Usage: ./testPairSamp.sh  media events E1 E2 step norm
  media: such as Fe BGO Air ...
  events: # of events (samplings) for each energy
  E1 E2: kinetic energy of muon(GeV); form E1 to at least E2
  step:  log10 step of energy"
  norm:  1: /r.l 2:mb  3:/(g/cm2) 4: /cm   5:  area normalization
EOF
  exit
fi


media=$1; nevent=$2; E1=$3; E2=$4; step=$5; norm=$6 

nbin=`awk  'END {nbin=int(log(E2/E1)/log(10.)/step)+1;print nbin}'   E1=$E1 E2=$E2 step=$step /dev/null`
#echo nbin is $nbin
#exit
Ek=$E1

rm -f $work/mupair*.png
make -f muPrSamp.mk
make -f DrawMuPairFunc.mk
for f in $(seq 1 $nbin); do
  echo ${f}-th energy=$Ek 

  echo $norm  $media $Ek  | ./drawmupair.out > $work/pair.func


#   get total normalization const. ( 1/(total prob/r.l))
  Nc=`awk '{print $4; exit}' $work/pair.func` 
  echo "Nc =" $Nc
  ANc=`awk '{print $5; exit}' $work/pair.func` 
  echo "ANc =" $ANc
#   output pair.func is Nc*ds/dx  ( prob/r.l)
#     dN/dx/N= ds/dx/tprob
#     tprob/N * dN/dx = ds/dx
#    Nc*tprob/N * dN/dx = Nc*ds/dx = output above 
#     ANc = tprob  

  Ncc=`echo  $ANc $Nc  $nevent | awk '{print $3/($1*$2)}'`   
echo "Ncc=" $Ncc

  echo $nevent $Ek $media  |time  ./a.out  | awk '{print $1}' | histo -l 1.e-5 0.01 $Ncc  > $work/pair.hist



  echo "Ek=${Ek}" > $work/gnuplot.com

  cat pair.gp >> $work/gnuplot.com

  echo  set output  \"$work/pair${f}.png\" >>$work/gnuplot.com
  echo  rep  >>$work/gnuplot.com

  gnuplot $work/gnuplot.com

  Ek=`awk 'END {Ek=Ek*10.**step;print Ek}' Ek=$Ek step=$step /dev/null`
done
