      subroutine epCreBrSTbl1(mediain, cnst)
      implicit none
#include "Zmedia.h"
#include "Zmass.h"
#include "ZBPgene.h"

c     *                                                             
c     *       create sampling table for Bremstrahlung 
c     *       at low energies where
c     *       LPM effect can be neglected
c     *       all other correction included                    
c
      record /epmedia/mediain  !  media
      record /SmpCnst/ cnst  ! must be media.cnst
c


c
      integer ws
      parameter (ws = 10000)
      real*8 work(ws), work2(ws)
c        cp mediain into common area
      media = mediain
      call epwtBrCnst(cnst)

c            total x-sec.
      if( cnst.BremTXTL .gt. mxBrTXL) then
         call cerrorMsg(
     *     'too large total X-sec.table for low E bresm', 0)
      endif
      call epCreBrTXTL(cnst, work, work2,  cnst.BremTXTL)

c           sampling table in A region
      if( cnst.BremUszLA * cnst.BremEsize .gt. mxBrTblLA) then
         call cerrorMsg('brem table for LA is too large', 0)
      endif
      call  epCreBrLA(cnst, work, cnst.BremUszLA, cnst.BremEsize)

c           sampling table in B region
      if( cnst.BremUszLB * cnst.BremEsize .gt. mxBrTblLB) then
         call cerrorMsg('brem table for LB is too large', 0)
      endif
      call  epCreBrLB(cnst, work, cnst.BremUszLB, cnst.BremEsize)
      end

c     ****************************************
      subroutine epCreBrTXTL(cnst, erg,  tbl, size)
c     ****************************************
      implicit none
#include "Zmedia.h"
#include "Zmass.h"
#include "ZBPgene.h"

      record /SmpCnst/ cnst  ! must be media.cnst
      integer size
      real*8  tbl(size), erg(size)

      real*8 E,  vmax, vmin,  tcb, de
      character*160 msg
      integer i



      write(msg,*) ' Matter=', media.name,
     *  ': Computing the total Xsec of Brems from Ee= ',
     *    cnst.BremEemin, ' GeV'
      call cerrorMsg(msg, 1)
      write(0,*) ' log step =',cnst.BremdETXL, ' size=',size
      write(0,*)

      E = cnst.BremEemin*1.000001d0
      de = 10.d0**cnst.BremdETXL
      do   i=1, size

         call epChkEndValSc(E, i, size)

         Eeme = E/masele
         vmax=1.d0 - 1.0001d0 * masele/ E
c         vmin=cnst.BremEgmin/E
         vmin=cnst.BremEgmin
         if(vmin .ge.  vmax) then
            call cerrorMsg('Eg/E <= vmin', 0)
         endif
c         call eptotcb(vmin,  vmax,  tcb)
         call epBrgeneTX(vmin,  vmax,  tcb)
         tbl(i) = tcb* media.mbtoPX0  ! prob. per radiation length.
         erg(i) = E
         E = E * de
      enddo
      write(msg, *) 'Table has been made up to  E=', E/de,' GeV'
      call cerrorMsg(msg, 1)
      write(msg, *) 'Brems total X-sec. table upto E=',
     *     E/de,' GeV'
      call epwt1dTbl(msg, erg, tbl, size, media.name)

      end

c     **********************************************
      subroutine epCreBrLA(cnst, bla, sizeu,  sizee)
      implicit none
#include "Zmedia.h"
#include "Zmass.h"
#include "ZBPgene.h"

      record /SmpCnst/ cnst  ! must be media.cnst
      integer sizeu, sizee 
      real*8  bla(sizeu,  sizee)

      real*8 de1, E, vmin, vl, vr, u, tcb, vx, tcbx,
     *  tcbleft, tcbright, eps, v

      external epBrgeneSolv
      real*8  epBrgeneSolv

      real*8  epBrgenex

      character*160 msg
      integer i, iu, j


      common/upsic/upsi, vmax
      real*8 vmax, upsi

      data eps/1.d-5/


      de1 = 10.d0**cnst.BremdEL

      E = cnst.BremEemin*1.000001d0

      write(msg, *) ' Creating Brem sampling table P.S region: E>=',
     *    cnst.BremEemin
      call cerrorMsg(msg, 1)
      write(msg, *) ' for small Eg region; log step= ',cnst.BremdEL
      call cerrorMsg(msg, 1)
      write(0, *) ' size=', sizee



      do  i = 1, sizee
         call epChkEndValSc(E, i, sizee)
         Eeme = E/masele
c         vmin=cnst.BremEgmin/E
         vmin=cnst.BremEgmin
c         vmax=1.d0 - 1.00000001d0* masele/E
         vmax=1.d0 -  masele/E
         
c         call eptotcb(vmin, vmax, tcb)
         call epBrgeneTX(vmin, vmax, tcb)
         vl=vmin
         vr=vmax
         
         u=cnst.BremUminLA
         
         do  iu=1, sizeu -1
            
            upsi=u*tcb
            call kbchop(epBrgeneSolv, vl, vr, eps, v, j)
            
            if(j.le.0) then
               
               write(0, *) ' a-- cond, E, u=', j, E, u
               do vx = vmin, vmax, (vmax-vmin)/100.d0
c                  call eptotcb(vx, vmax, tcbx)
                  call epBrgeneTX(vx, vmax, tcbx)
                  
                  write(0, *) vx, tcbx
               enddo
               write(0,*) 'u upsi, vl, vr', u,
     *              upsi, vl, vr,
     *              ' vmin=', vmin, ' tcb=', tcb
c               call eptotcb(vl,vmax,tcbleft)
c               call eptotcb(vr,vmax,tcbright)
               call epBrgeneTX(vl,vmax,tcbleft)
               call epBrgeneTX(vr,vmax,tcbright)
               
               write(0, *) ' tcb at vl, vr=', tcbleft,
     *              tcbright
            endif
            bla(iu,i)= log(v/vmin)/(1.-u)
            u=u + cnst.BremdULA
c            vr = v
         enddo
c         bla(sizeu, i)=tcb/vmin/epBremS(vmin)
         bla(sizeu, i)=tcb/vmin/epBrgenex(vmin)
         E =E* de1
      enddo

      call epwt2dTbl(
     *  'Brems sampling table at low E for Small Eg',
     *   bla, sizeu, sizee)
      call cerrorMsg('the table has been created', 1)

      end

c     ***********************************************
      subroutine epCreBrLB(cnst, blb, sizeu,  sizee)
      implicit none
#include "Zmedia.h"
#include "Zmass.h"
#include "ZBPgene.h"

      record /SmpCnst/ cnst  ! must be media.cnst
      integer sizeu, sizee 
      real*8  blb(sizeu, sizee)

      real*8 de1, E, vmin, vl, vr, u, tcb, 
     *   eps, us, v, temp

      external epBrgeneSolv
      real*8  epBrgeneSolv
      real*8  epBrgenex

      integer  iu, j, ie


      common/upsic/upsi, vmax
      real*8 vmax, upsi

c      data eps/1.d-5/


      call cerrorMsg(
     * 'Creating brems sampling table P.S for large Eg', 1)

      E = cnst.BremEemin*1.000001d0

      de1 = 10.d0**cnst.BremdEL
c      do ie = 1, cnst.BremEsize
      do ie = 1, sizee
          call epChkEndValSc(E, ie, sizee)
          Eeme = E/masele


c          vmin=cnst.BremEgmin/E
          vmin=cnst.BremEgmin
c          vmax=1.d0 - 1.00000001d0 * masele/E
          vmax=1.d0 -  masele/E
c          call eptotcb(vmin, vmax, tcb)
          call epBrgeneTX(vmin, vmax, tcb)
          vl=vmin
          vr=vmax
          us=cnst.BremUminLB + cnst.BremdULB
c          do   iu = 2,  cnst.BremUszLB
          do   iu = 2,  sizeu
             u=us**4
             upsi=u*tcb
             if(iu .le .5) then
                eps = 1.d-7
             else
                eps = 1.d-5
             endif

             call kbchop(epBrgeneSolv, vl, vr, eps, v, j)
             if(j .le. 0) then
                write(0,'(''b-- E,u='',2g12.3)') E, u
             endif
             blb(iu,ie) = log(vmax/v)/u
             us=us + cnst.BremdULB
c             vr = v
          enddo
c          temp = epBremS(vmax)
          temp = epBrgenex(vmax)
          if(temp .ne. 0.) then
             blb(1, ie) = tcb/vmax/temp
          else
             blb(1, ie) = blb(2, ie)
          endif

          E= E*de1
       enddo
       
       call epwt2dTbl('Brems sampling tbl at low E for large Eg',
     *  blb, sizeu, sizee)
       call cerrorMsg('the table has been created', 1)
       end
      subroutine  epChkEndValSc(Ee, ie, sizee)
      implicit none
#include "Zmedia.h"
#include "Zmass.h"
#include "ZBPgene.h"

      real*8 Ee  ! in/out

      integer ie, sizee
c            table end value should not exceed the region end value
      if(ie .eq. sizee) then
         if(Ee .ge. media.cnst.BrScrE) then
            if(Ee .gt. media.cnst.BrScrE*1.0001d0) then
               write(0,*) '*********** too large end value *** '
               write(0,*) 'Ee=',Ee, 
     *           '  > media.cnst.BrScrE*1.001d0=',
     *           media.cnst.BrScrE*1.0001d0
               stop
            endif
            Ee = media.cnst.BrScrE*0.99999999d0
         endif
      endif
      end
